#include "stdafx.h"
#include "win_demo.h"
#include "DialogIOAlarm.h"
#include "afxdialogex.h"
#include "sdks.h"
#include "common_struct.h"
#include "perser_json.h"
#include "pack_json.h"

extern int m_handle;
extern int m_chn_option;
IMPLEMENT_DYNAMIC(CDialogIOAlarm, CDialogEx)

CDialogIOAlarm::CDialogIOAlarm(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_DIALOG_IO_ALARM, pParent)
{

}

CDialogIOAlarm::~CDialogIOAlarm()
{
}

void CDialogIOAlarm::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_ALARM_SRC_NAME, m_io_alarm_name);
	DDX_Control(pDX, IDC_EDIT_ALARM_INTERVAL, m_io_alarm_interval);
	DDX_Control(pDX, IDC_COMBO_ALARM_DATE, m_io_alarm_week);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H1, m_start_time_h1);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M1, m_start_time_m1);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H1, m_end_time_h1);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M1, m_end_time_m1);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H2, m_start_time_h2);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M2, m_start_time_m2);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H2, m_end_time_h2);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M2, m_end_time_m2);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H3, m_start_time_h3);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M3, m_start_time_m3);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H3, m_end_time_h3);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M3, m_end_time_m3);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H4, m_start_time_h4);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M4, m_start_time_m4);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H4, m_end_time_h4);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M4, m_end_time_m4);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H5, m_start_time_h5);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M5, m_start_time_m5);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H5, m_end_time_h5);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M5, m_end_time_m5);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H6, m_start_time_h6);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M6, m_start_time_m6);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H6, m_end_time_h6);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M6, m_end_time_m6);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H7, m_start_time_h7);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M7, m_start_time_m7);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H7, m_end_time_h7);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M7, m_end_time_m7);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H8, m_start_time_h8);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M8, m_start_time_m8);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H8, m_end_time_h8);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M8, m_end_time_m8);
}

jy_dev_io_alarm_param_list_t io_alarm_param_list = { 0 };
jy_dev_show_schedule_time_list_t show_schedule_time_list = { 0 };
BOOL CDialogIOAlarm::OnInitIOAlarm()
{
	char *p_result = NULL;
	int nRet = 0;
	CString strins;
	nRet = sdks_dev_get_io_alarm_event(m_handle, m_chn_option, 1, &p_result);
	if (0 == nRet)
	{
		memset(&io_alarm_param_list, 0, sizeof(jy_dev_io_alarm_param_list_t));
		json_perser_io_alarm(p_result, &io_alarm_param_list);
		((CButton*)GetDlgItem(IDC_CHECK_IO_ALARM_FLAG))->SetCheck(0);
		if (io_alarm_param_list.io_param_list[0].enable)
		{
			((CButton*)GetDlgItem(IDC_CHECK_IO_ALARM_FLAG))->SetCheck(1);
		}
		m_io_alarm_name.SetWindowTextA(io_alarm_param_list.io_param_list[0].source_name);
		strins.Format(_T("%d"), io_alarm_param_list.io_param_list[0].alarm_interval);
		m_io_alarm_interval.SetWindowTextA(strins);
		m_io_alarm_week.ResetContent();
		m_io_alarm_week.InsertString(0, TEXT("Sun"));
		m_io_alarm_week.InsertString(1, TEXT("Mon"));
		m_io_alarm_week.InsertString(2, TEXT("Tue"));
		m_io_alarm_week.InsertString(3, TEXT("Wed"));
		m_io_alarm_week.InsertString(4, TEXT("Thur"));
		m_io_alarm_week.InsertString(5, TEXT("Fri"));
		m_io_alarm_week.InsertString(6, TEXT("Sat"));
		m_io_alarm_week.SetCurSel(0);
		memset(&show_schedule_time_list, 0, sizeof(jy_dev_show_schedule_time_list_t));
		for (int i = 0; i < io_alarm_param_list.io_param_list[0].schedule_time_size; ++i)
		{
			switch (io_alarm_param_list.io_param_list[0].schedule_time_list[i].week_day)
			{
			case 0:
				show_schedule_time_list.show_time_list[0].schedule_time_list[show_schedule_time_list.show_time_list[0].list_size].week_day = io_alarm_param_list.io_param_list[0].schedule_time_list[i].week_day;
				show_schedule_time_list.show_time_list[0].schedule_time_list[show_schedule_time_list.show_time_list[0].list_size].start_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].start_time;
				show_schedule_time_list.show_time_list[0].schedule_time_list[show_schedule_time_list.show_time_list[0].list_size].end_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].end_time;
				++show_schedule_time_list.show_time_list[0].list_size;
				break;
			case 1:
				show_schedule_time_list.show_time_list[1].schedule_time_list[show_schedule_time_list.show_time_list[1].list_size].week_day = io_alarm_param_list.io_param_list[0].schedule_time_list[i].week_day;
				show_schedule_time_list.show_time_list[1].schedule_time_list[show_schedule_time_list.show_time_list[1].list_size].start_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].start_time;
				show_schedule_time_list.show_time_list[1].schedule_time_list[show_schedule_time_list.show_time_list[1].list_size].end_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].end_time;
				++show_schedule_time_list.show_time_list[1].list_size;
				break;
			case 2:
				show_schedule_time_list.show_time_list[2].schedule_time_list[show_schedule_time_list.show_time_list[2].list_size].week_day = io_alarm_param_list.io_param_list[0].schedule_time_list[i].week_day;
				show_schedule_time_list.show_time_list[2].schedule_time_list[show_schedule_time_list.show_time_list[2].list_size].start_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].start_time;
				show_schedule_time_list.show_time_list[2].schedule_time_list[show_schedule_time_list.show_time_list[2].list_size].end_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].end_time;
				++show_schedule_time_list.show_time_list[2].list_size;
				break;
			case 3:
				show_schedule_time_list.show_time_list[3].schedule_time_list[show_schedule_time_list.show_time_list[3].list_size].week_day = io_alarm_param_list.io_param_list[0].schedule_time_list[i].week_day;
				show_schedule_time_list.show_time_list[3].schedule_time_list[show_schedule_time_list.show_time_list[3].list_size].start_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].start_time;
				show_schedule_time_list.show_time_list[3].schedule_time_list[show_schedule_time_list.show_time_list[3].list_size].end_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].end_time;
				++show_schedule_time_list.show_time_list[3].list_size;
				break;
			case 4:
				show_schedule_time_list.show_time_list[4].schedule_time_list[show_schedule_time_list.show_time_list[4].list_size].week_day = io_alarm_param_list.io_param_list[0].schedule_time_list[i].week_day;
				show_schedule_time_list.show_time_list[4].schedule_time_list[show_schedule_time_list.show_time_list[4].list_size].start_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].start_time;
				show_schedule_time_list.show_time_list[4].schedule_time_list[show_schedule_time_list.show_time_list[4].list_size].end_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].end_time;
				++show_schedule_time_list.show_time_list[4].list_size;
				break;
			case 5:
				show_schedule_time_list.show_time_list[5].schedule_time_list[show_schedule_time_list.show_time_list[5].list_size].week_day = io_alarm_param_list.io_param_list[0].schedule_time_list[i].week_day;
				show_schedule_time_list.show_time_list[5].schedule_time_list[show_schedule_time_list.show_time_list[5].list_size].start_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].start_time;
				show_schedule_time_list.show_time_list[5].schedule_time_list[show_schedule_time_list.show_time_list[5].list_size].end_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].end_time;
				++show_schedule_time_list.show_time_list[5].list_size;
				break;
			case 6:
				show_schedule_time_list.show_time_list[6].schedule_time_list[show_schedule_time_list.show_time_list[6].list_size].week_day = io_alarm_param_list.io_param_list[0].schedule_time_list[i].week_day;
				show_schedule_time_list.show_time_list[6].schedule_time_list[show_schedule_time_list.show_time_list[6].list_size].start_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].start_time;
				show_schedule_time_list.show_time_list[6].schedule_time_list[show_schedule_time_list.show_time_list[6].list_size].end_time = io_alarm_param_list.io_param_list[0].schedule_time_list[i].end_time;
				++show_schedule_time_list.show_time_list[6].list_size;
				break;
			default:break;
			}
		}
		OnCbnSelchangeComboAlarmDate();
	}
	return TRUE;
}

BEGIN_MESSAGE_MAP(CDialogIOAlarm, CDialogEx)
	ON_CBN_SELCHANGE(IDC_COMBO_ALARM_DATE, &CDialogIOAlarm::OnCbnSelchangeComboAlarmDate)
	ON_BN_CLICKED(IDOK2, &CDialogIOAlarm::OnBnClickedOk2)
	ON_BN_CLICKED(IDOK, &CDialogIOAlarm::OnBnClickedOk)
END_MESSAGE_MAP()


void CDialogIOAlarm::clear_date_edit()
{
	m_start_time_h1.SetWindowTextA("");
	m_start_time_m1.SetWindowTextA("");
	m_end_time_h1.SetWindowTextA("");
	m_end_time_m1.SetWindowTextA("");
}

static int conversion_time (int src_time, int &res_hours, int &res_min)
{
	res_hours = src_time / 3600;
	res_min = (src_time - (res_hours * 3600)) / 60;
	return 0;
}

void CDialogIOAlarm::show_date_info(int week, jy_dev_show_schedule_time_list_t *schedule_time_list)
{
	CString strins;
	int start_hours;
	int start_min;
	int end_hours;
	int end_min;
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[0].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[0].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h1.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m1.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h1.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m1.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[1].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[1].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h2.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m2.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h2.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m2.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[2].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[2].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h3.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m3.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h3.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m3.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[3].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[3].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h4.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m4.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h4.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m4.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[4].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[4].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h5.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m5.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h5.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m5.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[5].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[5].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h6.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m6.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h6.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m6.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[6].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[6].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h7.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m7.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h7.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m7.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[7].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[7].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h8.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m8.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h8.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m8.SetWindowTextA(strins);
}

void CDialogIOAlarm::OnCbnSelchangeComboAlarmDate()
{
	int week = m_io_alarm_week.GetCurSel();
	clear_date_edit();
	show_date_info(week, &show_schedule_time_list);
}


void CDialogIOAlarm::OnBnClickedOk2()
{
	CString str_tmp;
	int tmp_start_hours;
	int tmp_start_min;
	int tmp_end_hours;
	int tmp_end_min;
	int week = m_io_alarm_week.GetCurSel();
	memset(&show_schedule_time_list.show_time_list[week], 0, sizeof(jy_dev_show_schedule_time_t));
	m_start_time_h1.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m1.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h1.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m1.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) < ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			show_schedule_time_list.show_time_list[week].schedule_time_list[0].week_day = week;
			show_schedule_time_list.show_time_list[week].schedule_time_list[0].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			show_schedule_time_list.show_time_list[week].schedule_time_list[0].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++show_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h2.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m2.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h2.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m2.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			show_schedule_time_list.show_time_list[week].schedule_time_list[1].week_day = week;
			show_schedule_time_list.show_time_list[week].schedule_time_list[1].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			show_schedule_time_list.show_time_list[week].schedule_time_list[1].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++show_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h3.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m3.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h3.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m3.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			show_schedule_time_list.show_time_list[week].schedule_time_list[2].week_day = week;
			show_schedule_time_list.show_time_list[week].schedule_time_list[2].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			show_schedule_time_list.show_time_list[week].schedule_time_list[2].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++show_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h4.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m4.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h4.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m4.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			show_schedule_time_list.show_time_list[week].schedule_time_list[3].week_day = week;
			show_schedule_time_list.show_time_list[week].schedule_time_list[3].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			show_schedule_time_list.show_time_list[week].schedule_time_list[3].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++show_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h5.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m5.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h5.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m5.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			show_schedule_time_list.show_time_list[week].schedule_time_list[4].week_day = week;
			show_schedule_time_list.show_time_list[week].schedule_time_list[4].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			show_schedule_time_list.show_time_list[week].schedule_time_list[4].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++show_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h6.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m6.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h6.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m6.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			show_schedule_time_list.show_time_list[week].schedule_time_list[5].week_day = week;
			show_schedule_time_list.show_time_list[week].schedule_time_list[5].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			show_schedule_time_list.show_time_list[week].schedule_time_list[5].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++show_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h7.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m7.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h7.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m7.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			show_schedule_time_list.show_time_list[week].schedule_time_list[6].week_day = week;
			show_schedule_time_list.show_time_list[week].schedule_time_list[6].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			show_schedule_time_list.show_time_list[week].schedule_time_list[6].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++show_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h8.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m8.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h8.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m8.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			show_schedule_time_list.show_time_list[week].schedule_time_list[7].week_day = week;
			show_schedule_time_list.show_time_list[week].schedule_time_list[7].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			show_schedule_time_list.show_time_list[week].schedule_time_list[7].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++show_schedule_time_list.show_time_list[week].list_size;
	}
}


void CDialogIOAlarm::OnBnClickedOk()
{
	CString str_tmp;
	int schedule_size = 0;
	char *p_param = NULL;
	io_alarm_param_list.io_param_list[0].enable = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_IO_ALARM_FLAG))->GetCheck() == TRUE)
	{
		io_alarm_param_list.io_param_list[0].enable = 1;
	}
	m_io_alarm_name.GetWindowText(str_tmp);
	strcpy(io_alarm_param_list.io_param_list[0].source_name, (char*)str_tmp.GetBuffer(str_tmp.GetLength()));
	m_io_alarm_interval.GetWindowText(str_tmp);
	io_alarm_param_list.io_param_list[0].alarm_interval = _ttoi(str_tmp);
	for (int i = 0; i < 7; ++i)
	{
		for (int j = 0; j < show_schedule_time_list.show_time_list[i].list_size; ++j)
		{
			io_alarm_param_list.io_param_list[0].schedule_time_list[schedule_size].week_day = show_schedule_time_list.show_time_list[i].schedule_time_list[j].week_day;
			io_alarm_param_list.io_param_list[0].schedule_time_list[schedule_size].start_time = show_schedule_time_list.show_time_list[i].schedule_time_list[j].start_time;
			io_alarm_param_list.io_param_list[0].schedule_time_list[schedule_size].end_time = show_schedule_time_list.show_time_list[i].schedule_time_list[j].end_time;
			++schedule_size;
		}
	}
	io_alarm_param_list.io_param_list[0].schedule_time_size = schedule_size;
	UINT i = 0;
	i = MessageBoxA(_T("Are you sure you want to set the I/O alarm?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
	if (IDYES == i)
	{
		pack_json_io_alarm(&io_alarm_param_list, &p_param);
		int nRet = sdks_dev_json_set_io_alarm_para(m_handle, p_param);
		if (nRet) {
			MessageBoxA("Set disk alarm param fail!");
		}
	}
}
